<?php
define('IN_BOT',true);
require 'config.php';
require 'functions.php';

// دریافت Update
$update = json_decode(file_get_contents('php://input'), true);
if(!$update) exit;

$chat_id = $update['message']['chat']['id'] ?? null;
$text = $update['message']['text'] ?? null;
$callback = $update['callback_query'] ?? null;

// بررسی کاربر در دیتابیس
$user = getUserByTelegramId($chat_id);

// شروع ثبت نام
if(!$user){
    if(isset($update['message']['contact'])){
        $phone = $update['message']['contact']['phone_number'];
        $first_name = $update['message']['contact']['first_name'] ?? '';
        $last_name = $update['message']['contact']['last_name'] ?? '';
        $gender = ''; // بعداً از دکمه شیشه‌ای می‌گیریم

        saveUser($chat_id, $first_name, $last_name, $phone, $gender);
        sendMessage($chat_id,"✅ ثبت نام شما با موفقیت انجام شد. برای ادامه، /start را ارسال کنید.");
        exit;
    } else {
        // پیام خوش آمد و درخواست شماره تماس
        sendMessage($chat_id,"👋 سلام! برای استفاده از ربات، لطفا شماره تماس خود را ارسال کنید:", [
            'keyboard'=>[[['text'=>"📞 ارسال شماره","request_contact"=>true]]],
            'resize_keyboard'=>true,
            'one_time_keyboard'=>true
        ]);
        exit;
    }
}

// بعد از ثبت نام، ادامه کاربر و ثبت آگهی مرحله‌ای
// بررسی محدودیت آگهی‌های فعال کاربر
if(userActiveAdsCountThisMonth($chat_id) >= getSetting('max_ads')){
    sendMessage($chat_id,"⚠️ شما در این ماه به حد مجاز ثبت آگهی رسیده‌اید.");
    exit;
}

// دریافت مرحله فعلی ثبت آگهی
$stmt = $pdo->prepare("SELECT * FROM user_state WHERE telegram_id=?");
$stmt->execute([$chat_id]);
$state = $stmt->fetch();

if(!$state){
    // شروع مرحله اول ثبت آگهی
    $step = 'ad_type';
    $temp_data = [];
    $stmt = $pdo->prepare("INSERT INTO user_state (telegram_id, step, temp_data) VALUES (?,?,?)");
    $stmt->execute([$chat_id,$step,json_encode($temp_data,JSON_UNESCAPED_UNICODE)]);

    sendMessage($chat_id,"🏷 لطفا نوع آگهی را انتخاب کنید:", [
        'inline_keyboard'=>[
            [['text'=>"💰 فروش",'callback_data'=>'ad_type_sale']],
            [['text'=>"🏠 اجاره",'callback_data'=>'ad_type_rent']]
        ]
    ]);
    exit;
}

$step = $state['step'];
$temp_data = json_decode($state['temp_data'], true);
// ==================== ثبت آگهی مرحله‌ای ====================

// پردازش Callback برای انتخاب نوع آگهی
if($callback){
    $data = $callback['data'];

    if($step=='ad_type'){
        if($data=='ad_type_sale') $temp_data['type']='فروش';
        if($data=='ad_type_rent') $temp_data['type']='اجاره';

        updateUserState($chat_id,'property_type',$temp_data);

        sendMessage($chat_id,"🏘 لطفا نوع ملک را انتخاب کنید:",[
            'inline_keyboard'=>[
                [['text'=>'🏠 آپارتمان','callback_data'=>'property_apartment']],
                [['text'=>'🏡 ویلایی','callback_data'=>'property_villa']],
                [['text'=>'🌳 زمین','callback_data'=>'property_land']],
                [['text'=>'🏢 تجاری','callback_data'=>'property_commercial']],
                [['text'=>'📦 انباری','callback_data'=>'property_storage']]
            ]
        ]);
        exit;
    }

    // انتخاب نوع ملک
    if($step=='property_type'){
        $types_map = [
            'property_apartment'=>'آپارتمان',
            'property_villa'=>'ویلایی',
            'property_land'=>'زمین',
            'property_commercial'=>'تجاری',
            'property_storage'=>'انباری'
        ];
        if(isset($types_map[$data])){
            $temp_data['property_type']=$types_map[$data];
            updateUserState($chat_id,'title',$temp_data);
            sendMessage($chat_id,"✏️ لطفا عنوان آگهی را وارد کنید:");
            exit;
        }
    }
}

// ادامه مراحل با پیام متنی
if($text && $step){
    switch($step){
        case 'title':
            $temp_data['title']=$text;
            updateUserState($chat_id,'area',$temp_data);
            sendMessage($chat_id,"📏 لطفا متراژ ملک را به متر مربع وارد کنید (عدد فقط):");
            break;

        case 'area':
            if(!is_numeric($text)){
                sendMessage($chat_id,"⚠️ لطفا عدد معتبر وارد کنید.");
                exit;
            }
            $temp_data['area']=$text;
            updateUserState($chat_id,'price',$temp_data);
            sendMessage($chat_id, $temp_data['type']=='اجاره' ? "💰 لطفا مبلغ رهن و کرایه ماهانه را وارد کنید:" : "💰 لطفا قیمت ملک را وارد کنید:");
            break;

        case 'price':
            if(!is_numeric($text)){
                sendMessage($chat_id,"⚠️ لطفا عدد معتبر وارد کنید.");
                exit;
            }
            $temp_data['price']=$text;
            updateUserState($chat_id,'address',$temp_data);
            sendMessage($chat_id,"📍 لطفا آدرس ملک را وارد کنید:");
            break;

        case 'address':
            $temp_data['address']=$text;
            updateUserState($chat_id,'description',$temp_data);
            sendMessage($chat_id,"📝 لطفا توضیحات تکمیلی را وارد کنید:");
            break;

        case 'description':
            $temp_data['description']=$text;
            updateUserState($chat_id,'images',$temp_data);
            sendMessage($chat_id,"🖼 لطفا تصاویر ملک را ارسال کنید (حداکثر 4 تصویر). اگر نمی‌خواهید تصویر ارسال کنید، روی دکمه زیر کلیک کنید:",[
                'inline_keyboard'=>[
                    [['text'=>'ثبت بدون تصویر','callback_data'=>'no_images']]
                ]
            ]);
            break;
    }
}
// ==================== دریافت تصاویر ====================
if($callback && $callback['data']=='no_images' && $step=='images'){
    $temp_data['images']=[];
    // ثبت نهایی آگهی بدون تصویر
    finalizeAd($chat_id, $temp_data);
    sendMessage($chat_id,"✅ آگهی شما با موفقیت ثبت شد و پس از تایید مدیر در کانال منتشر خواهد شد.");
    clearUserState($chat_id);
    exit;
}

// دریافت تصویر
if(isset($update['message']['photo']) && $step=='images'){
    $photos = $update['message']['photo'];
    $last_photo = end($photos); // بزرگترین رزولوشن
    $file_id = $last_photo['file_id'];

    // دانلود و ذخیره تصویر
    $file_path = downloadTelegramFile($file_id);
    if(!isset($temp_data['images'])) $temp_data['images']=[];
    if(count($temp_data['images'])<4){
        $temp_data['images'][]=$file_path;
        updateUserState($chat_id,'images',$temp_data);
        sendMessage($chat_id,"🖼 تصویر دریافت شد (".count($temp_data['images'])."/4). اگر تمام شد، روی دکمه ثبت بدون تصویر کلیک کنید:");
    } else {
        sendMessage($chat_id,"⚠️ حداکثر 4 تصویر مجاز است.");
    }
}

// ==================== ثبت نهایی آگهی در دیتابیس ====================
function finalizeAd($chat_id,$data){
    global $pdo;

    $payload = json_encode($data, JSON_UNESCAPED_UNICODE);
    $encrypted = encryptData($payload);

    $stmt = $pdo->prepare("INSERT INTO ads (user_id, type, property_type, title, area, price, address, description, images, post_date, status, encrypted_payload) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)");
    $stmt->execute([
        $chat_id,
        $data['type'],
        $data['property_type'],
        $data['title'],
        $data['area'],
        $data['price'],
        $data['address'],
        $data['description'],
        json_encode($data['images'], JSON_UNESCAPED_UNICODE),
        date('Y-m-d'),
        'در انتظار تایید', // ابتدا منتظر تایید مدیر
        $encrypted
    ]);
}
// ==================== پنل مدیریت ====================
if(isAdmin($chat_id) && $text=='/admin'){
    $keyboard = [
        [
            ['text'=>'📋 آگهی‌های در انتظار تایید','callback_data'=>'admin_pending_ads']
        ],
        [
            ['text'=>'📊 آمار کلی','callback_data'=>'admin_stats'],
            ['text'=>'⚙️ تنظیمات','callback_data'=>'admin_settings']
        ],
        [
            ['text'=>'📢 پیام همگانی','callback_data'=>'admin_broadcast']
        ]
    ];
    sendMessage($chat_id,"👑 پنل مدیریت ربات:", ['inline_keyboard'=>$keyboard]);
    exit;
}

// ==================== آگهی‌های در انتظار تایید ====================
if($callback && $callback['data']=='admin_pending_ads' && isAdmin($chat_id)){
    $stmt=$pdo->prepare("SELECT * FROM ads WHERE status='در انتظار تایید'");
    $stmt->execute();
    $ads=$stmt->fetchAll();

    if(!$ads){
        sendMessage($chat_id,"❌ آگهی در انتظار تایید وجود ندارد.");
        exit;
    }

    foreach($ads as $ad){
        $text="🆔 کد آگهی: #".$ad['id']." | ".$ad['type']." ".$ad['property_type']."\n".
              "✳️ عنوان: ".$ad['title']."\n".
              "⏮️ متراژ: ".$ad['area']." متر مربع\n".
              "💵 قیمت: ".$ad['price']." تومان\n".
              "📍 آدرس: ".$ad['address']."\n".
              "📝 توضیحات: ".$ad['description']."\n".
              "👤 آگهی دهنده: ".getUserName($ad['user_id'])."\n".
              "☎️ تماس: ".getUserPhone($ad['user_id'])."\n".
              "👁 تاریخ انتشار: ".jdate($ad['post_date']);

        $keyboard=[[
            ['text'=>'✅ تایید','callback_data'=>'approve_'.$ad['id']],
            ['text'=>'❌ رد','callback_data'=>'reject_'.$ad['id']]
        ]];

        sendMessage($chat_id,$text,['inline_keyboard'=>$keyboard]);
    }
    exit;
}

// ==================== تایید یا رد آگهی توسط مدیر ====================
if($callback && preg_match('/^(approve|reject)_(\d+)$/',$callback['data'],$matches) && isAdmin($chat_id)){
    $action = $matches[1];
    $ad_id = $matches[2];

    $stmt=$pdo->prepare("SELECT * FROM ads WHERE id=?");
    $stmt->execute([$ad_id]);
    $ad=$stmt->fetch();

    if(!$ad) exit;

    if($action=='approve'){
        $stmt=$pdo->prepare("UPDATE ads SET status='تایید' WHERE id=?");
        $stmt->execute([$ad_id]);
        sendMessage($ad['user_id'],"✅ آگهی شما با عنوان (".$ad['title'].") تایید شد و در کانال منتشر خواهد شد.");

        // ارسال به کانال
        $message_text = "🆔 کد آگهی: #".$ad['id']." | ".$ad['type']." ".$ad['property_type']."\n".
                        "✳️ عنوان آگهی: ".$ad['title']."\n".
                        "⏮️ متراژ: ".$ad['area']." متر مربع\n".
                        "💵 قیمت: ".$ad['price']." تومان\n".
                        "📝 توضیحات تکمیلی: ".$ad['description']."\n".
                        "👤 آگهی دهنده: ".getUserName($ad['user_id'])."\n".
                        "☎️ تماس: ".getUserPhone($ad['user_id'])."\n".
                        "👁 تاریخ انتشار: ".jdate($ad['post_date']);

        $resp = file_get_contents("https://api.telegram.org/bot".BOT_TOKEN."/sendMessage?".http_build_query([
            'chat_id'=>CHANNEL_ID,
            'text'=>$message_text,
            'parse_mode'=>'Markdown'
        ]));

        $resp_data = json_decode($resp,true);
        $channel_message_id = $resp_data['result']['message_id'] ?? null;

        // ذخیره message_id برای حذف احتمالی بعدی
        $stmt=$pdo->prepare("UPDATE ads SET channel_message_id=? WHERE id=?");
        $stmt->execute([$channel_message_id,$ad_id]);

        sendMessage($chat_id,"✅ آگهی تایید و ارسال شد.");
    }

    if($action=='reject'){
        $stmt=$pdo->prepare("UPDATE ads SET status='رد' WHERE id=?");
        $stmt->execute([$ad_id]);
        sendMessage($ad['user_id'],"❌ آگهی شما با عنوان (".$ad['title'].") رد شد.");
        sendMessage($chat_id,"✅ آگهی رد شد.");
    }

    exit;
}
// ==================== آمار کلی ====================
if($callback && $callback['data']=='admin_stats' && isAdmin($chat_id)){
    $users_count = $pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();
    $ads_count = $pdo->query("SELECT COUNT(*) FROM ads")->fetchColumn();
    $blocked_count = $pdo->query("SELECT COUNT(*) FROM users WHERE blocked=1")->fetchColumn();

    $text="📊 آمار کلی ربات:\n".
          "👤 تعداد کاربران: $users_count\n".
          "📝 تعداد آگهی‌ها: $ads_count\n".
          "⛔️ تعداد کاربران مسدود شده: $blocked_count";

    sendMessage($chat_id,$text);
    exit;
}

// ==================== تنظیمات ربات ====================
if($callback && $callback['data']=='admin_settings' && isAdmin($chat_id)){
    $keyboard=[
        [['text'=>'✏️ متن خوش‌آمدگویی','callback_data'=>'set_welcome_text']],
        [['text'=>'✏️ تعداد آگهی مجاز','callback_data'=>'set_max_ads']],
        [['text'=>'⏳ مدت اعتبار آگهی (روز)','callback_data'=>'set_ad_expiry']],
        [['text'=>'🏷️ آیدی کانال','callback_data'=>'set_channel_id']]
    ];
    sendMessage($chat_id,"⚙️ تنظیمات ربات:",['inline_keyboard'=>$keyboard]);
    exit;
}

// ==================== پیام همگانی ====================
if($callback && $callback['data']=='admin_broadcast' && isAdmin($chat_id)){
    setUserState($chat_id,'broadcast_message');
    sendMessage($chat_id,"📢 لطفا متن پیام همگانی را ارسال کنید:");
    exit;
}

if($step=='broadcast_message' && $text){
    $stmt=$pdo->query("SELECT telegram_id FROM users");
    $users=$stmt->fetchAll();

    foreach($users as $u){
        sendMessage($u['telegram_id'],$text);
    }

    sendMessage($chat_id,"✅ پیام همگانی ارسال شد.");
    clearUserState($chat_id);
    exit;
}

// ==================== پروفایل کاربر ====================
if($text=='👤 پروفایل من'){
    $user = getUserByTelegramId($chat_id);
    $text="👤 شناسه: ".$user['telegram_id']."\n".
          "📝 نام و نام خانوادگی: ".$user['first_name']." ".$user['last_name']."\n".
          "📞 شماره تماس: ".$user['phone']."\n".
          "⚧ جنسیت: ".$user['gender']."\n".
          "📅 تاریخ عضویت: ".jdate($user['join_date']);

    $keyboard=[[
        ['text'=>'❌ حذف حساب کاربری','callback_data'=>'delete_user']
    ]];

    sendMessage($chat_id,$text,['inline_keyboard'=>$keyboard]);
    exit;
}

// ==================== حذف حساب کاربری ====================
if($callback && $callback['data']=='delete_user'){
    $keyboard=[[
        ['text'=>'✅ بله','callback_data'=>'confirm_delete_user'],
        ['text'=>'❌ خیر','callback_data'=>'cancel_delete_user']
    ]];
    sendMessage($chat_id,"⚠️ آیا مایل به حذف حساب کاربری هستید؟",$keyboard);
    exit;
}

if($callback && $callback['data']=='confirm_delete_user'){
    deleteUser($chat_id);
    sendMessage($chat_id,"✅ حساب کاربری شما حذف شد.");
    exit;
}

if($callback && $callback['data']=='cancel_delete_user'){
    sendMessage($chat_id,"❌ عملیات حذف لغو شد.");
    exit;
}

// ==================== حذف آگهی توسط کاربر ====================
if($callback && preg_match('/^delete_ad_(\d+)$/',$callback['data'],$matches)){
    $ad_id = $matches[1];
    userDeleteAd($ad_id,$chat_id);
    sendMessage($chat_id,"✅ آگهی حذف شد.");
    exit;
}
