<?php
function encrypt_secret(string $plaintext): string {
    $key = BOT_SECRET_KEY;
    $nonce = random_bytes(SODIUM_CRYPTO_SECRETBOX_NONCEBYTES);
    $cipher = sodium_crypto_secretbox($plaintext, $nonce, $key);
    return base64_encode($nonce . $cipher);
}

function decrypt_secret(string $b64) {
    $key = BOT_SECRET_KEY;
    $decoded = base64_decode($b64, true);
    if ($decoded === false) return false;
    $nonceLen = SODIUM_CRYPTO_SECRETBOX_NONCEBYTES;
    if (strlen($decoded) <= $nonceLen) return false;
    $nonce = substr($decoded, 0, $nonceLen);
    $cipher = substr($decoded, $nonceLen);
    $plain = sodium_crypto_secretbox_open($cipher, $nonce, $key);
    return $plain === false ? false : $plain;
}
