<?php
// ---------------- CONFIG ----------------
define('BOT_TOKEN','YOUR_BOT_TOKEN_HERE');
define('ADMIN_ID','YOUR_ADMIN_ID_HERE');
define('DB_HOST','localhost');
define('DB_NAME','telegram_ads');
define('DB_USER','root');
define('DB_PASS','');
define('AD_EXPIRE_DAYS',14);
define('MAX_ADS_PER_USER',6);
define('CHANNEL_ID','@yourchannelid');
define('SECRET_KEY','YOUR_SECRET_KEY'); // رمزنگاری

// ---------------- DATABASE ----------------
function db(){
    try{
        $pdo = new PDO("mysql:host=".DB_HOST.";dbname=".DB_NAME.";charset=utf8", DB_USER, DB_PASS);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        return $pdo;
    }catch(Exception $e){
        die("Database Error: ".$e->getMessage());
    }
}

// ---------------- ENCRYPTION ----------------
function encrypt($data){
    return openssl_encrypt($data,'aes-256-cbc',SECRET_KEY,0,'1234567890123456');
}
function decrypt($data){
    return openssl_decrypt($data,'aes-256-cbc',SECRET_KEY,0,'1234567890123456');
}

// ---------------- DATE SHAMSI ----------------
function today_shamsi(){
    $dt = new DateTime();
    $dt->setTimezone(new DateTimeZone('Asia/Tehran'));
    $gDate = $dt->format('Y-m-d');
    // تبدیل شمسی
    list($y,$m,$d)=explode('-',$gDate);
    return gregorian_to_jalali($y,$m,$d);
}

// ---------------- GREGORIAN TO JALALI ----------------
function gregorian_to_jalali($gy,$gm,$gd){
    $g_days_in_month = array(31,28,31,30,31,30,31,31,30,31,30,31);
    $j_days_in_month = array(31,31,31,31,31,31,30,30,30,30,30,29);
    $gy2 = ($gm > 2)?($gy + 1):$gy;
    $days = 355666 + (365*$gy) + (int)(($gy2+3)/4) - (int)(($gy2+99)/100) + (int)(($gy2+399)/400) + $gd;
    for($i=0;$i<$gm-1;$i++) $days += $g_days_in_month[$i];
    $jy = -1595 + (33*floor($days/12053));
    $days %= 12053;
    $jy += 4*floor($days/1461);
    $days %= 1461;
    if($days > 365){
        $jy += floor(($days-1)/365);
        $days = ($days-1)%365;
    }
    for($i=0;$i<11 && $days >= $j_days_in_month[$i];$i++) $days -= $j_days_in_month[$i];
    $jm = $i+1;
    $jd = $days+1;
    return $jy.'-'.$jm.'-'.$jd;
}

// ---------------- SEND MESSAGE ----------------
function sendMessage($chat_id,$text){
    $url = "https://api.telegram.org/bot".BOT_TOKEN."/sendMessage";
    $data = ['chat_id'=>$chat_id,'text'=>$text,'parse_mode'=>'HTML'];
    file_get_contents($url.'?'.http_build_query($data));
}

// ---------------- SEND BUTTON ----------------
function sendButton($chat_id,$text,$buttons){
    $keyboard = ['inline_keyboard'=>$buttons];
    $data = ['chat_id'=>$chat_id,'text'=>$text,'parse_mode'=>'HTML','reply_markup'=>json_encode($keyboard)];
    $url = "https://api.telegram.org/bot".BOT_TOKEN."/sendMessage";
    file_get_contents($url.'?'.http_build_query($data));
}

// ---------------- DELETE MESSAGE ----------------
function deleteMessage($chat_id,$message_id){
    $url = "https://api.telegram.org/bot".BOT_TOKEN."/deleteMessage";
    file_get_contents($url.'?chat_id='.$chat_id.'&message_id='.$message_id);
}

// ---------------- SEND AD TO CHANNEL ----------------
function sendAdToChannel($user_id,$ad){
    $msg = "🆔 کد آگهی: #{$ad['id']} | {$ad['ad_type']} {$ad['property_type']}\n".
           "✳️ عنوان آگهی: {$ad['title']}\n".
           "⏮️ متراژ: {$ad['area']} متر مربع\n".
           "💵 قیمت: {$ad['price']}\n".
           "📝 توضیحات: {$ad['description']}\n\n".
           "👤 آگهی دهنده: ".decrypt($ad['first_name'])." ".decrypt($ad['last_name'])."\n".
           "☎️ تماس: ".decrypt($ad['phone'])."\n".
           "👁 تاریخ انتشار: {$ad['created_at']}";
    
    if(!empty($ad['photos'])){
        $photos = json_decode($ad['photos'],true);
        foreach($photos as $photo){
            $url = "https://api.telegram.org/bot".BOT_TOKEN."/sendPhoto";
            file_get_contents($url.'?chat_id='.CHANNEL_ID.'&photo='.$photo.'&caption='.urlencode($msg));
        }
    } else {
        sendMessage(CHANNEL_ID,$msg);
    }

    // ذخیره message_id در دیتابیس اگر لازم باشد برای حذف بعدی
}

// ---------------- DELETE AD ----------------
function deleteAd($ad_id){
    $pdo = db();
    $stmt = $pdo->prepare("SELECT * FROM ads WHERE id=?");
    $stmt->execute([$ad_id]);
    $ad = $stmt->fetch(PDO::FETCH_ASSOC);
    if(!$ad) return;

    // حذف پیام از کانال (در صورتی که message_id ذخیره شده باشد)
    if(!empty($ad['message_id'])){
        deleteMessage(CHANNEL_ID,$ad['message_id']);
    }

    // حذف از دیتابیس
    $stmt = $pdo->prepare("DELETE FROM ads WHERE id=?");
    $stmt->execute([$ad_id]);
}
